import 'package:admin_desktop/app_constants.dart';
import 'package:admin_desktop/infrastructure/services/extensions.dart';
import 'package:admin_desktop/infrastructure/services/time_service.dart';
import 'package:admin_desktop/presentation/components/buttons/has_more_button.dart';
import 'package:admin_desktop/presentation/components/dialogs/delete_dialog.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/catalogue/widgets/service/widgets/service_pop_up.dart';
import 'package:flutter/material.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:pull_to_refresh/pull_to_refresh.dart';
import 'package:remixicon_updated/remixicon_updated.dart';

import 'package:admin_desktop/application/catalogue/catalogue_provider.dart';
import '../../../../../../../../domain/models/data/service_data.dart';
import '../../../../../../../../infrastructure/services/app_helpers.dart';
import '../../../../../../../../infrastructure/services/tr_keys.dart';
import 'package:admin_desktop/presentation/components/buttons/custom_refresher.dart';
import 'package:admin_desktop/presentation/components/custom_checkbox.dart';
import 'package:admin_desktop/presentation/components/image/common_image.dart';
import 'package:admin_desktop/presentation/components/login_button.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import '../riverpod/service/edit/edit_service_provider.dart';
import '../riverpod/service/service_provider.dart';

class ServiceTablePage extends ConsumerStatefulWidget {
  const ServiceTablePage({super.key});

  @override
  ConsumerState<ServiceTablePage> createState() => _ServiceTablePageState();
}

class _ServiceTablePageState extends ConsumerState<ServiceTablePage> {
  late RefreshController refreshController;

  @override
  void initState() {
    refreshController = RefreshController();
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) {
        ref
            .read(serviceProvider.notifier)
            .fetchAllServices(context: context, isRefresh: true);
      },
    );
  }

  @override
  Widget build(BuildContext context) {
    final state = ref.watch(serviceProvider);
    final notifier = ref.read(serviceProvider.notifier);
    return Scaffold(
      backgroundColor: Colors.transparent,
      body: LayoutBuilder(builder: (context, constraints) {
        return SingleChildScrollView(
          child: Column(
            children: [
              Row(
                children: [
                  Text(
                    AppHelpers.getTranslation(TrKeys.service),
                    style: Style.interMedium(size: 20),
                  ),
                  const Spacer(),
                  CustomRefresher(
                      onTap: () {
                        notifier.fetchAllServices(
                            context: context, isRefresh: true);
                      },
                      isLoading: state.isLoading),
                  Padding(
                    padding: const EdgeInsets.all(12.0),
                    child: LoginButton(
                      bgColor: Style.black,
                      icon: Icon(
                        Remix.add_circle_line,
                        color: Style.white,
                        size: 24.r,
                      ),
                      onPressed: () {
                        //  Navigator.push(context, MaterialPageRoute(builder: (_)=>AddServicePage()));
                        ref.read(catalogueProvider.notifier).changeState(4);
                      },
                      title: AppHelpers.getTranslation(TrKeys.addService),
                    ),
                  )
                ],
              ),
              _topRow(constraints, ref),
              state.isLoading
                  ? _loading()
                  : Column(
                      children: [
                        ...state.allServices.mapIndexed((e, i) {
                          return _tableRow(
                            e,
                            constraints,
                            ref,
                            onTap: () {
                              ref
                                  .read(editServiceProvider.notifier)
                                  .setDetails(
                                    state.allServices[i],
                                  )
                                  .then((v) => ref
                                      .read(catalogueProvider.notifier)
                                      .changeState(5));
                            },
                            onDelete: () {
                              AppHelpers.showAlertDialog(context: context, child: DeleteDialog(success: (){
                                Navigator.pop(context);
                                ref
                                    .read(serviceProvider.notifier)
                                    .deleteService(
                                    context, state.allServices[i].id)
                                    .then((value) {
                                  if (context.mounted) {
                                    ref
                                        .read(serviceProvider.notifier)
                                        .fetchAllServices(
                                        context: context, isRefresh: true);
                                  }
                                });
                              }));

                            },
                          );
                        })
                      ],
                    ),
              16.verticalSpace,
              if (state.hasMore)
                HasMoreButton(
                    hasMore: state.hasMore,
                    onViewMore: () {
                      notifier.fetchAllServices(context: context);
                    })
            ],
          ),
        );
      }),
    );
  }

  Container _tableRow(ServiceData service, BoxConstraints constraints, WidgetRef ref,
      {required VoidCallback onTap, required VoidCallback onDelete}) {
    return Container(
      width: double.infinity,
      height: 60,
      decoration: BoxDecoration(
          color: Style.white,
          border: Border.fromBorderSide(BorderSide(color: Style.greyColor))),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          12.horizontalSpace,
          CustomCheckbox(
            isActive:
                ref.watch(serviceProvider).selectProducts.contains(service.id),
            onTap: () {
              ref.read(serviceProvider.notifier).addSelectOrder(
                  id: service.id,
                  orderLength: ref.watch(serviceProvider).allServices.length);
            },
          ),
          12.horizontalSpace,
          SizedBox(
            width: constraints.maxWidth / 17,
            child: Text("${service.id}"),
          ),
          12.horizontalSpace,
          (service.galleries?.isNotEmpty ?? true)
              ? CommonImage(
                  url: service.galleries?.first.path ?? "",
                  width: 60,
                  height: 56,
                  isResponsive: false,
                )
              : CommonImage(
                  width: 60,
                  height: 56,
                  isResponsive: false,
                ),
          32.horizontalSpace,
          SizedBox(
              width: constraints.maxWidth / 6,
              child: Text(service.translation?.title ?? "-")),
          20.horizontalSpace,
          SizedBox(
              width: constraints.maxWidth / 6,
              child: Text(AppHelpers.getTranslation(
                  service.category?.translation?.title ?? "  -"))),
          20.horizontalSpace,
          SizedBox(
              width: constraints.maxWidth / 7,
              child: Text(AppHelpers.getTranslation(service.type ?? ""))),
          20.horizontalSpace,
          if (constraints.maxWidth > 1100)
            SizedBox(
                width: constraints.maxWidth / 5,
                child: Text(TimeService.dateFormatMDYHm(service.createdAt))),
          Spacer(),
          ServicePopUp(onEdit: onTap, onDelete: onDelete),
          12.horizontalSpace,
        ],
      ),
    );
  }

  Container _topRow(BoxConstraints constraints, WidgetRef ref) {
    return Container(
      width: double.infinity,
      height: 60,
      decoration: BoxDecoration(
          color: Style.white,
          borderRadius: BorderRadius.only(
            topLeft: Radius.circular(AppConstants.radius),
            topRight: Radius.circular(AppConstants.radius),
          ),
          border: Border.fromBorderSide(BorderSide(color: Style.greyColor))),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          12.horizontalSpace,
          CustomCheckbox(
            isActive: ref.watch(serviceProvider).isAllSelect,
            onTap: () {
              ref
                  .read(serviceProvider.notifier)
                  .allSelectOrder(ref.watch(serviceProvider).allServices);
            },
          ),
          12.horizontalSpace,
          SizedBox(
              width: constraints.maxWidth / 17,
              child: Text(
                AppHelpers.getTranslation(TrKeys.id),
                style: Style.interMedium(),
              )),
          12.horizontalSpace,
          SizedBox(
              width: 60,
              child: Text(
                AppHelpers.getTranslation(TrKeys.image),
                style: Style.interMedium(),
              )),
          32.horizontalSpace,
          SizedBox(
              width: constraints.maxWidth / 6,
              child: Text(
                AppHelpers.getTranslation(TrKeys.name),
                style: Style.interMedium(),
              )),
          20.horizontalSpace,
          SizedBox(
              width: constraints.maxWidth / 6,
              child: Text(
                AppHelpers.getTranslation(TrKeys.category),
                style: Style.interMedium(),
              )),
          20.horizontalSpace,
          SizedBox(
              width: constraints.maxWidth / 7,
              child: Text(
                AppHelpers.getTranslation(TrKeys.service),
                style: Style.interMedium(),
              )),
          20.horizontalSpace,
          if (constraints.maxWidth > 1100)
            SizedBox(
                width: constraints.maxWidth / 5,
                child: Text(
                  AppHelpers.getTranslation(TrKeys.createdDate),
                  style: Style.interMedium(),
                )),
        ],
      ),
    );
  }

  ListView _loading() {
    return ListView.builder(
        itemCount: 10,
        shrinkWrap: true,
        itemBuilder: (context, index) {
          return Container(
            height: 60,
            width: double.infinity,
            decoration: BoxDecoration(
                color: Style.greyColor,
                border: Border.fromBorderSide(BorderSide(color: Style.white))),
          );
        });
  }
}
